﻿<%@ Page Language="c#" CodePage="1200" %>

<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>

<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.SrodkiTrwale" %>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html>
<head>
	<title>Zmiana wartości</title>
	<script runat="server">
  
		void Dokument_OnLoad(Object sender, EventArgs args)
		{
			ZmianaWartosciDok dokument = (ZmianaWartosciDok)DataContext1.Get(typeof(ZmianaWartosciDok));
			SrodekTrwalyBaseHistoria hist = dokument.Pozycja.SrodekTrwaly[dokument.DataOperacji];

			ReportHeader1.Title = String.Format(ReportHeader1.Title,
				hist.WybierzNazwe("Zmiana wartości i ilości środka trwałego", "Zmiana wartości i ilości wartości niematerialnej/prawnej", "Zmiana wartości i ilości wyposażenia"),
				dokument.Numer, dokument.Data, dokument.DataOperacji, dokument.Tytul);

			DataLabelNrInw.EditValue = hist.Srodek.NumerInwentarzowy;
			DataLabelNazwa.EditValue = hist.Srodek.Nazwa;
			DataLabelOpis.EditValue = hist.Srodek.Opis;
			DataLabelKST.EditValue = hist.KRST.Symbol;
			DataLabelNrFabryczny.EditValue = hist.Srodek.NumerFabryczny;

			var zmianaIlosci = dokument.ZmianaIlosci;
			IdIloscZmiana.EditValue = String.Format("{0} {1}", Math.Abs(zmianaIlosci), dokument.Historia != null ? dokument.Historia.JednostkaMiary.ToString() : String.Empty);

			if (zmianaIlosci < 0)
				IdIloscKierunek.EditValue = "Zmiejszenie ilości";
			else if (zmianaIlosci > 0)
				IdIloscKierunek.EditValue = "Zwiększenie ilości";
			else
				IdIloscKierunek.EditValue = "Bez zmiany ilości";
		}

	</script>

</head>
<body>
	<form id="Dokument" method="post" runat="server">
		<ea:DataContext ID="DataContext1" runat="server" TypeName="Soneta.SrodkiTrwale.ZmianaWartosciDok,Soneta.Ksiega" OnContextLoad="Dokument_OnLoad" />
		<cc1:ReportHeader id="ReportHeader1" runat="server" title="{0} {1} | Data: {2}, Data operacji: {3} | Tytuł: {4}" />
		<p />

		<table id="Table1" cellspacing="0" cellpadding="1" width="100%" border="1">
			<colgroup width="20%"></colgroup>
			<colgroup width="30%"></colgroup>
			<colgroup width="20%"></colgroup>
			<colgroup width="30%"></colgroup>

			<tr>
				<td><font face="Tahoma" size="2">Nr inwentarzowy:</font></td>
				<td><ea:DataLabel ID="DataLabelNrInw" EncodeHTML="true" runat="server" ContextTypeName="Soneta.SrodkiTrwale.ZmianaWartosciDok,Soneta.Ksiega"></ea:DataLabel></td>
				<td><font face="Tahoma" size="2">Nazwa:</font></td>
				<td><ea:DataLabel ID="DataLabelNazwa" EncodeHTML="true" runat="server" ContextTypeName="Soneta.SrodkiTrwale.ZmianaWartosciDok,Soneta.Ksiega"></ea:DataLabel></td>
			</tr>
			<tr>
				<td><font face="Tahoma" size="2">KŚT:</font></td>
				<td><ea:DataLabel ID="DataLabelKST" EncodeHTML="true" runat="server" ContextTypeName="Soneta.SrodkiTrwale.ZmianaWartosciDok,Soneta.Ksiega"></ea:DataLabel></td>
				<td><font face="Tahoma" size="2">Nr fabryczny:</font></td>
				<td><ea:DataLabel ID="DataLabelNrFabryczny" EncodeHTML="true" runat="server" ContextTypeName="Soneta.SrodkiTrwale.ZmianaWartosciDok,Soneta.Ksiega"></ea:DataLabel>&nbsp;</td>
			</tr>
			<tr>
				<td style="height: 23px"><font face="Tahoma" size="2">Opis:</font></td>
				<td colspan="3" style="height: 23px"><ea:DataLabel ID="DataLabelOpis" EncodeHTML="true" runat="server" ContextTypeName="Soneta.SrodkiTrwale.ZmianaWartosciDok,Soneta.Ksiega"></ea:DataLabel>&nbsp; </td>
			</tr>
		</table>

		<p />
		<div style="font-weight: bold; font-size: 8pt; width: 100%; border-bottom: thin solid; font-family: Verdana">
			Zmiana ilości
		</div>
		<table id="Table4" cellspacing="0" cellpadding="1" width="100%" border="1">
			<colgroup width="30%"></colgroup>
			<colgroup width="70%"></colgroup>

			<tr>
				<td ><span style="font-size: 10pt; font-family: Tahoma">&nbsp; </span>	</td>
				<td style="text-align: center;">	<font face="Tahoma" size="2">Zmiana ilości</font></td>
			</tr>
			<tr>
				<td style="height: 23px;"><span style="font-size: 10pt; font-family: Tahoma">Kierunek:</span></td>
				<td style="height: 23px;" align="right"><ea:DataLabel ID="IdIloscKierunek" runat="server" /></td>
			</tr>
			<tr>
				<td style="height: 23px;"><span style="font-size: 10pt; font-family: Tahoma">Zmiana:</span></td>
				<td style="height: 23px;" align="right"><ea:DataLabel ID="IdIloscZmiana" runat="server" /></td>
			</tr>
		</table>


		<p />
		<div style="font-weight: bold; font-size: 8pt; width: 100%; border-bottom: thin solid; font-family: Verdana">
			Zmiana wartości
		</div>
		<table id="Table2" cellspacing="0" cellpadding="1" width="100%" border="1">
			<colgroup width="30%"></colgroup>
			<colgroup width="35%"></colgroup>
			<colgroup width="35%"></colgroup>

			<tr>
				<td><span style="font-size: 10pt; font-family: Tahoma">&nbsp; </span>	</td>
				<td style="text-align: center;">	<font face="Tahoma" size="2">Bilansowo</font></td>
				<td style="text-align: center"><span style="font-size: 10pt; font-family: Tahoma">Podatkowo</span></td>
			</tr>
			<tr>
				<td style="height: 23px;"><span style="font-size: 10pt; font-family: Tahoma">Kierunek:</span></td>
				<td style="height: 23px;" align="right"><ea:DataLabel ID="DataLabel1" runat="server" DataMember="PozycjaZW.Kierunek"></ea:DataLabel></td>
				<td style="height: 23px" align="right"><ea:DataLabel ID="DataLabel2" runat="server" DataMember="PozycjaZW.Kierunek"></ea:DataLabel></td>
			</tr>
			<tr>
				<td style="height: 23px;"><span style="font-size: 10pt; font-family: Tahoma">Zmiana:</span></td>
				<td style="height: 23px;" align="right"><ea:DataLabel ID="label11" runat="server" DataMember="PozycjaZW.WartoscBilansowa"></ea:DataLabel></td>
				<td style="height: 23px" align="right"><ea:DataLabel ID="label14" runat="server" DataMember="PozycjaZW.WartoscPodatkowa"></ea:DataLabel></td>
			</tr>
		</table>

		<p />
		<div style="font-weight: bold; font-size: 8pt; width: 100%; border-bottom: thin solid; font-family: Verdana">
			Korekta umorzenia
		</div>
		<table id="Table3" cellspacing="0" cellpadding="1" width="100%" border="1">
			<colgroup width="30%"></colgroup>
			<colgroup width="35%"></colgroup>
			<colgroup width="35%"></colgroup>

			<tr>
				<td><span style="font-size: 10pt; font-family: Tahoma">&nbsp; </span>	</td>
				<td style="text-align: center;">	<font face="Tahoma" size="2">Bilansowo</font></td>
				<td style="text-align: center"><span style="font-size: 10pt; font-family: Tahoma">Podatkowo</span></td>
			</tr>
			<tr>
				<td style="height: 22px"><span style="font-size: 10pt; font-family: Tahoma" id="Zmiana">Korekta:</span></td>
				<td style="height: 22px;" align="right"><ea:DataLabel ID="DataLabel5" runat="server" DataMember="KorektaAmortyzacjiBilansowej"></ea:DataLabel></td>
				<td style="height: 22px;" align="right"><ea:DataLabel ID="DataLabel15" runat="server" DataMember="KorektaAmortyzacjiPodatkowej"></ea:DataLabel>
				</td>
			</tr>
		</table>

		<p />
		<cc1:ReportFooter ID="ReportFooter1" runat="server">
			<subtitles>
				<cc1:FooterSubtitle Caption="Uwagi" Width="100" runat="server" />
				<cc1:FooterSubtitle Caption="Zlecił" Width="45" runat="server" SubtitleType="Podpis" />
				<cc1:FooterSubtitle Caption="Wykonał" runat="server" SubtitleType="Podpis" Width="45" />
			</subtitles>
		</cc1:ReportFooter>
	</form>
</body>
</html>

